//
//  bdlive_viewer_player_delegate_impl.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.



import 'package:bdlive_flutter_viewer/src/base/bdlive_enum_convert.dart';
import '../api/bdlive_viewer_player_delegate.dart';
import '../api/bdlive_model.dart';

extension BdliveViewerPlayerDelegateExtension on BdliveViewerPlayerDelegate {
  void process(String methodName, Map<dynamic, dynamic> dic) {
    switch (methodName) {
      case 'liveRoomStatusChanged':
        BdLiveRoomStatus status = (dic['status'] as int).liveRoomStatus;
        liveRoomStatusChanged?.call(status);
        break;
      case 'playableStatusChanged':
        BdlivePlayableStatus status = (dic['playableStatus'] as int).playableStatus;
        playableStatusChanged?.call(status);
        break;
      case 'isPlayingChanged':
        bool isPlaying = dic['isPlaying'];
        isPlayingChanged?.call(isPlaying);
        break;
      case 'videoSizeChanged':
        int width = dic['width'];
        int height = dic['height'];
        videoSizeChanged?.call(width, height);
        break;
      case 'isStallingChanged':
        bool isStalling = dic['isStalling'];
        isStallingChanged?.call(isStalling);
        break;
      case 'vodErrorOccurred':
        BdliveError error = BdliveError.fromMap(dic['error']);
        vodErrorOccurred?.call(error);
        break;
      case 'liveErrorOccurred':
        BdliveError error = BdliveError.fromMap(dic['error']);
        liveErrorOccurred?.call(error);
        break;
      case 'playErrorStatusChanged':
        bool isPlayError = dic['isPlayError'];
        playErrorStatusChanged?.call(isPlayError);
        break;
      case 'vodPrepared':
        vodPrepared?.call();
        break;
      case 'vodRenderStarted':
        vodRenderStarted?.call();
        break;
      case 'vodAutoSeekPreviousTime':
        int seekTimeInMills = dic['seekTimeInMills'];
        vodAutoSeekPreviousTime?.call(seekTimeInMills);
        break;
      case 'vodCurPlayTimeChanged':
        int curTimeInMills = dic['curTimeInMills'];
        vodCurPlayTimeChanged?.call(curTimeInMills);
        break;
      case 'vodDurationChanged':
        int durationInMills = dic['durationInMills'];
        vodDurationChanged?.call(durationInMills);
        break;
      case 'livePrepared':
        livePrepared?.call();
        break;
      case 'liveFirstFrameRendered':
        bool isFirstFrame = dic['isFirstFrame'];
        liveFirstFrameRendered?.call(isFirstFrame);
        break;
      case 'coverImageVisibleChanged':
        bool isVisible = dic['isVisible'];
        coverImageVisibleChanged?.call(isVisible);
        break;
      case 'resolutionInfoChanged':
        List<int> resolutions = dic['resolutions'].cast<int>();
        int defaultResolution = dic['defaultResolution'];
        var list = resolutions.map((e) => e.videoResolution).toList();
        resolutionInfoChanged?.call(list, defaultResolution.videoResolution);
        break;
      case 'coverImageSizeChanged':
        int width = dic['width'];
        int height = dic['height'];
        coverImageSizeChanged?.call(width, height);
        break;
      case 'onUserForceOffline':
        BdliveForceOfflineReason reason = (dic['reason'] as int).forceOfflineReason;
        onUserForceOffline?.call(reason);
        break;
      case 'onRelease':
        onRelease?.call();
        break;
      default:
        break;
    }
  }
}