//
//  bdlive_viewer_live_pull_view_impl.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
part of '../api/bdlive_viewer_live_pull_view_api.dart';

class _BdlivePullViewState extends State<BdlLivePullView> {
  //Flutter View工厂的VIEW_TYPE_ID
  String viewType = "BdlLivePullView";

  @override
  void initState() {
    super.initState();
    // 强制竖屏
    SystemChrome.setPreferredOrientations([
      DeviceOrientation.portraitUp,
    ]);
  }

  @override
  void dispose() {
    // 恢复系统设置，允许所有方向
    SystemChrome.setPreferredOrientations([
      DeviceOrientation.portraitUp,
      DeviceOrientation.landscapeLeft,
      DeviceOrientation.landscapeRight,
    ]);

    BdliveViewerApi.instance.dispatchWidgetSate(-1);
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return createPage();
  }

  Widget createPage() {
    if (defaultTargetPlatform == TargetPlatform.android) {
      return buildAndroidView();
    } else {
      return UiKitView(
        viewType: viewType,
        creationParamsCodec: const StandardMessageCodec(),
        creationParams: {},
        onPlatformViewCreated: (int viewId) {
          if (widget.onPlatformViewCreated != null) {
            widget.onPlatformViewCreated!();
          }
        },
      );
    }
  }

  Widget buildAndroidView() {
    return VisibilityDetector(
        key: Key(viewType),
        child: WillPopScope(
            child: AndroidView(
              viewType: viewType,
              creationParamsCodec: const StandardMessageCodec(),
              creationParams: {},
              onPlatformViewCreated: (int viewId) {
                if (widget.onPlatformViewCreated != null) {
                  widget.onPlatformViewCreated!();
                }
              },
            ),
            onWillPop: () async {
              bool isClose = await BdliveViewerApi.instance.onWillClose();
              return !isClose;
            }),
        onVisibilityChanged: (info) {
          bool isVisible = info.visibleFraction > 0;
          // 调用widget.onVisibleChanged回调
          BdliveViewerApi.instance.dispatchWidgetSate(isVisible ? 1 : 2);
          // 通过MethodChannel发送可见性变化事件到原生端
        });
  }
}
