//
//  bdlive_room_status_listener_extension.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:flutter/foundation.dart';

import '../api/bdlive_flutter_viewer_api.dart';
import '../api/bdlive_model.dart';

extension BdlLiveRoomStatusListenerExtension on BdlLiveRoomStatusListener {
  void process(String methodName, Map<dynamic, dynamic> dic) {
    debugPrint('BdlLiveRoomStatusListener process = $methodName $dic');
    switch (methodName) {
      case 'onLiveRoomActivityResume':
        debugPrint("case onLiveRoomActivityResume $dic['activity']");
        var activity = BdlActivityConfig.fromMap(dic['activity']);
        debugPrint("case onLiveRoomActivityResume $activity");
        onLiveRoomActivityResume?.call(activity);
        break;
      case 'onLiveRoomActivityPause':
        var activity = BdlActivityConfig.fromMap(dic['activity']);
        onLiveRoomActivityPause?.call(activity);
        break;
      case 'onLiveRoomFullDestroyed':
        var activity = BdlActivityConfig.fromMap(dic['activity']);
        onLiveRoomFullDestroyed?.call(activity);
        break;
      case 'onFloatViewWillAppear':
        var activity = BdlActivityConfig.fromMap(dic['activity']);
        onFloatViewWillAppear?.call(activity);
        break;
      case 'onFloatViewWillClose':
        var activity = BdlActivityConfig.fromMap(dic['activity']);
        onFloatViewWillClose?.call(activity);
        break;
      case 'onOpenUrlCallback':
        String url = dic['url'] ?? "";
        BdlViewerOpenUrlType type = BdlViewerOpenUrlType.values[(dic['type'] - 1) ?? 0];
        bool enableFloating = dic['enableFloating'] ?? false;
        onOpenUrlCallback?.call(url, type, enableFloating);
        break;
      case 'showLivePullView':
        var activity = BdlActivityConfig.fromMap(dic['activity']);
        showLivePullView?.call(activity);
        break;
      case 'hideLivePullView':
        var activity = BdlActivityConfig.fromMap(dic['activity']);
        hideLivePullView?.call(activity);
        break;
    }
  }
}