//
//  bdlive_event_channel.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'dart:async';
import 'package:flutter/services.dart';

class RTCEventChannel {
  final Stream<dynamic> _stream;
  StreamSubscription<dynamic>? _subscription;

  StreamSubscription<dynamic>? get subscription => _subscription;

  RTCEventChannel(String name)
      : _stream = EventChannel(name).receiveBroadcastStream();

  void listen(
      void Function(String methodName, Map<dynamic, dynamic> dic)? onData,
      {Function? onError,
        void Function()? onDone,
        bool? cancelOnError}) {
    cancel();
    _subscription = _stream.listen((event) {
      final methodName = event['methodName'] as String;
      onData?.call(methodName, event);
    }, onError: onError, onDone: onDone, cancelOnError: cancelOnError);
  }

  void cancel() {
    _subscription?.cancel();
    _subscription = null;
  }

  void pause([Future<void>? resumeSignal]) {
    _subscription?.pause(resumeSignal);
  }

  void resume() {
    _subscription?.resume();
  }

  bool? get isPaused => _subscription?.isPaused;
}
