//
//  bdlive_enum_convert.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:flutter/foundation.dart';
import '../../api/bdlive_model.dart';

E _convertEnumValue<E>(List<E> values, int? idx, E defaultValue) {
  if (idx == null || idx >= values.length || idx < 0) {
    debugPrint('Vod: Enum ($E) unknown value $idx');
    return defaultValue;
  }
  return values[idx];
}

extension LiveTypeValue on int? {
  BdLiveRoomStatus get liveRoomStatus {
    return _convertEnumValue(BdLiveRoomStatus.values, this, BdLiveRoomStatus.unknown);
  }
  BdlivePlayableStatus get playableStatus {
    return _convertEnumValue(BdlivePlayableStatus.values, this, BdlivePlayableStatus.unknown);
  }
  BdlivePlayerLayoutMode get playerLayoutMode {
    return _convertEnumValue(BdlivePlayerLayoutMode.values, this, BdlivePlayerLayoutMode.aspectFit);
  }
  BdliveForceOfflineReason get forceOfflineReason {
    return _convertEnumValue(BdliveForceOfflineReason.values, this, BdliveForceOfflineReason.multiLogin);
  }
  BdliveVideoResolution get videoResolution  {
    return _convertEnumValue(BdliveVideoResolution.values, this, BdliveVideoResolution.unknown);
  }
}
