//
//  bdlive_viewer_player_delegate.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'bdlive_model.dart';

class BdliveViewerPlayerDelegate {
  /// 直播状态发生改变。[status]直播房间状态
  void Function(BdLiveRoomStatus status)? liveRoomStatusChanged;
  /// 可播放状态发生改变。[status]直播房间状态
  void Function(BdlivePlayableStatus playableStatus)? playableStatusChanged;
  /// 播放状态发生改变。[isPlaying]播放状态
  void Function(bool isPlaying)? isPlayingChanged;
  /// 视频尺寸发生改变。[width]视频宽度,[height]视频高度
  void Function(int width, int height)? videoSizeChanged;
  /// 视频卡顿状态发生改变。[isStalling]视频卡顿状态
  void Function(bool isStalling)? isStallingChanged;
  /// 点播视频错误回调。[error]点播错误信息
  void Function(BdliveError error)? vodErrorOccurred;
  /// 直播错误回调。[error]直播错误信息
  void Function(BdliveError error)? liveErrorOccurred;
  /// 播放错误状态发生改变。[isPlayError]播放错误状态
  void Function(bool isPlayError)? playErrorStatusChanged;
  /// 点播视频准备好回调。
  void Function()? vodPrepared;
  /// 点播视频开始播放。
  void Function()? vodRenderStarted;
  /// 点播视频自动向前seek。[seekTimeInMills]seek的时间（单位：ms）
  void Function(int seekTimeInMills)? vodAutoSeekPreviousTime;
  /// 点播视频播放进度发生改变。[curTimeInMills]点播视频播放进度（单位：ms）
  void Function(int curTimeInMills)? vodCurPlayTimeChanged;
  /// 点播视频时长发生改变。[durationInMills]点播视频时长（单位：ms）
  void Function(int durationInMills)? vodDurationChanged;
  /// 直播内容准备好回调。
  void Function()? livePrepared;
  /// 直播首帧渲染回调。[isFirstFrame]是否首帧
  void Function(bool isFirstFrame)? liveFirstFrameRendered;
  /// 封面图是否可见。[isVisible]封面图是否可见
  void Function(bool isVisible)? coverImageVisibleChanged;
  /// 清晰度信息发生改变。[resolutions]清晰度列表,[defaultResolution]默认清晰度
  void Function(List<BdliveVideoResolution> resolutions, BdliveVideoResolution defaultResolution)? resolutionInfoChanged;
  /// 封面图尺寸发生改变。[width]封面图宽度,[height]封面图高度
  void Function(int width, int height)? coverImageSizeChanged;
  /// 用户被强制退出了。[reason]强制退出的原因
  void Function(BdliveForceOfflineReason reason)? onUserForceOffline;
  /// 播放器释放回调，之后不应再调用播放器的任何方法
  void Function()? onRelease;

  BdliveViewerPlayerDelegate({
    this.liveRoomStatusChanged,
    this.playableStatusChanged,
    this.isPlayingChanged,
    this.videoSizeChanged,
    this.isStallingChanged,
    this.vodErrorOccurred,
    this.liveErrorOccurred,
    this.playErrorStatusChanged,
    this.vodPrepared,
    this.vodRenderStarted,
    this.vodAutoSeekPreviousTime,
    this.vodCurPlayTimeChanged,
    this.vodDurationChanged,
    this.livePrepared,
    this.liveFirstFrameRendered,
    this.coverImageVisibleChanged,
    this.resolutionInfoChanged,
    this.coverImageSizeChanged,
    this.onUserForceOffline,
    this.onRelease,
  });

}
