//
//  bdlive_viewer_manager_api.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.



import 'dart:collection';

import '../src/bdlive_viewer_manager_impl.dart';

class TTSDKConfiguration {
  final String appID; // appID, Not empty, required
  final String liveLicenseFilePath; // Not empty, required, Live license local file path
  final String vodLicenseFilePath; // Not empty, required, VOD license local file path
  String? bundleID; // Unique ID of iOS App
  String? appName; // App name
  String? channel; // App channel name
  String? appVersion; // The version number of the app. A valid version number should contain 2 or more separators, for example 1.3.2

  TTSDKConfiguration({
    required this.appID,
    required this.liveLicenseFilePath,
    required this.vodLicenseFilePath,
    this.bundleID,
    this.appName,
    this.channel,
    this.appVersion,
  });

  Map<String, dynamic> toMap() {
    HashMap<String, dynamic> dic = HashMap();
    dic['appID'] = appID;
    dic['liveLicenseFilePath'] = liveLicenseFilePath;
    dic['vodLicenseFilePath'] = vodLicenseFilePath;
    if (bundleID != null) {
      dic['bundleID'] = bundleID;
    }
    if (appName != null) {
      dic['appName'] = appName;
    }
    if (channel != null) {
      dic['channel'] = channel;
    }
    if (appVersion != null) {
      dic['appVersion'] = appVersion;
    }
    return dic;
  }
}

abstract class BdliveViewerManager {
  static Future<void> startWithConfiguration(TTSDKConfiguration config) => BdliveViewerManagerImpl.startWithConfiguration(config);
}
