//
//  BdliveFlutterViewerDelegate.m
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.

#import "BdliveFlutterViewerDelegate.h"
#import <BPLive/BDLResponder.h>

@implementation BdliveFlutterViewerDelegate

+ (instancetype)eventHandlerWithName:(NSString*)name
                     binaryMessenger:(NSObject<FlutterBinaryMessenger>*)messenger {
    BdliveFlutterViewerDelegate *delegate = [super eventHandlerWithName:name binaryMessenger:messenger];
    return delegate;
}

- (void)openUrl:(NSString *)url enableFloating:(BOOL)enableFloating type:(BDLPageAdvertisementType)type {
    if (!url || ![url isKindOfClass:[NSString class]] || url.length == 0) {
        return;
    }
    [self emitEvent:@{
        @"url" : url ?: @"",
        @"enableFloating" : @(enableFloating),
        @"type" : @(type),
    } methodName:@"onOpenUrlCallback"];
}

- (void)showLivePullViewController:(BDLLivePullViewController *)livePullVC {
    if (self.autoShowView) {
        livePullVC.modalPresentationStyle = UIModalPresentationFullScreen;
        [[BDLResponder topViewController] presentViewController:livePullVC animated:YES completion:nil];
    }
    else {
        [self emitEvent:@{
            @"activity" : [self.activity yy_modelToJSONObject]
        } methodName:@"showLivePullView"];
    }
}

- (void)hideLivePullViewController:(BDLLivePullViewController *)livePullVC {
    if (self.autoShowView) {
        if (livePullVC.presentingViewController) {
            [livePullVC dismissViewControllerAnimated:YES completion:nil];
        }
    }
    else {
        [self emitEvent:@{
            @"activity" : [self.activity yy_modelToJSONObject]
        } methodName:@"hideLivePullView"];
    }
}

- (void)livePullViewControllerDidAppear:(BDLLivePullViewController *)livePullVC {
    [self emitEvent:@{
        @"activity" : [self.activity yy_modelToJSONObject]
    } methodName:@"onLiveRoomActivityResume"];
}

- (void)livePullViewControllerDidDisappear:(BDLLivePullViewController *)livePullVC {
    [self emitEvent:@{
        @"activity" : [self.activity yy_modelToJSONObject]
    } methodName:@"onLiveRoomActivityPause"];
}

- (void)livePullViewControllerWillDestroy:(BDLLivePullViewController *)livePullVC {
    [self emitEvent:@{
        @"activity" : [self.activity yy_modelToJSONObject]
    } methodName:@"onLiveRoomFullDestroyed"];
}

- (void)livePullViewController:(BDLLivePullViewController *)livePullVC didClickHeaderAd:(NSString *)url floatingEnable:(BOOL)floatingEnable {
    [self openUrl:url enableFloating:floatingEnable type:BDLPageAdvertisementTypePageHeaderAd];
}

@end
