//
//  BDLFLTLivePullView.m
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.


#import "BDLFLTLivePullView.h"
#import "BDLFLTResponder.h"
#import "BDLLivePullViewController+Flutter.h"

#import <BPLive/BPLive.h>
#import <Masonry/Masonry.h>

@interface BDLFLTLivePullView ()

@property (nonatomic, weak) BDLLivePullViewController *livePullVC;

@end

@implementation BDLFLTLivePullView

- (void)didMoveToWindow {
    [super didMoveToWindow];
    if (self.window) {
        BDLLivePullViewController *livePullVC = [[BDLLiveEngine sharedInstance] getLivePullViewController];
        if (livePullVC) {
            self.livePullVC = livePullVC;
            livePullVC.isFlutterViewAlive = YES;
            if (!livePullVC.parentViewController) {
                [[BDLFLTResponder firstUIViewControllerForView:self] addChildViewController:livePullVC];
            }
            [self addSubview:livePullVC.view];
            [livePullVC.view mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.edges.equalTo(self);
            }];
        }
    }
    else {
        [self.livePullVC removeFromParentViewController];
        [self.livePullVC.view removeFromSuperview];
    }
}

- (void)dealloc {
    _livePullVC.isFlutterViewAlive = NO;
    _livePullVC = nil;
    NSLog(@"debug %s", __func__);
}

@end
