//
//  vod_util.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.

import 'dart:io';

import 'package:byteplus_vod/ve_vod.dart';

class VodUtil {

  // Platform messages are asynchronous, so we initialize in an async method.
  static Future<void> initPlatformState(Map<String, dynamic> map) async {

    String _appID = map['appID'];
    String channel = map['channel'];
    String appVersion = map['appVersion'];
    String appName = map['appName'];
    String licPath = map['vodLicenseFilePath'];

    // open log module
    await FlutterTTSDKManager.openAllLog();

    // regist log callback
    TTFLogger.onLog = (logLevel, msg) {
      print(msg);
    };

    // please replace it with current channel, example "App Store" for iOS
    TTSDKVodConfiguration vodConfig = TTSDKVodConfiguration();
    vodConfig.cacheMaxSize = 300 * 1024 * 1024;
    TTSDKConfiguration sdkConfig = TTSDKConfiguration.defaultConfigurationWithAppIDAndLicPath(
        appID: _appID, licenseFilePath: licPath, channel: channel);
    sdkConfig.vodConfiguration = vodConfig;
    sdkConfig.appName = appName;
    sdkConfig.appVersion = appVersion;
    FlutterTTSDKManager.startWithConfiguration(sdkConfig);
    // deviceID
    // FlutterTTSDKManager.setCurrentUserUniqueID('test_1234');
    // String? uniqueID = await FlutterTTSDKManager.getCurrentUserUniqueID();
    // String? deviceID = await FlutterTTSDKManager.getDeviceID();
    // String? engineUniqueId = await FlutterTTSDKManager.getEngineUniqueId();
    // print("TTF -- uniqueId:$uniqueID deviceId:$deviceID engineUniqueId:$engineUniqueId");
  }


}