//
//  vod_page.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:byteplus_vod/ve_vod.dart';
import 'package:crypto/crypto.dart';

class VodPage extends StatefulWidget {

  final String url;
  const VodPage({super.key, required this.url});

  @override
  State<VodPage> createState() => _VodPageState();
}

class _VodPageState extends State<VodPage> {

  VodPlayerFlutter _player = VodPlayerFlutter();
  bool _isPlaying = true;

  initState() {
    super.initState();
    _initPlayer();
  }

  void _initPlayer() async{
    await _player.createPlayer();
    // media data loader cache video unique identification key, recommended  you can use unique url md5 string
    String cacheKey = encryptMd5(widget.url);
    TTVideoEngineUrlSource source = TTVideoEngineUrlSource.initWithURL(widget.url, cacheKey);
    await _player.setMediaSource(source);

    await _player.play();
  }
  //MD5
  String encryptMd5(String str) {
    final utf = utf8.encode(str);
    final digest = md5.convert(utf);
    final encryptStr = digest.toString();
    return encryptStr;
  }

// 在 Build 方法中引用前面创建的 TTVideoPlayerView
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: GestureDetector(
        onTap: () async {
          print("GestureDetector onTap");
          if (_isPlaying) {
            await _player.pause();
          } else {
            await _player.play();
          }
          setState(() {
            _isPlaying =!_isPlaying;
          });
        },
        child: Container(
          width: MediaQuery.of(context).size.width,
          height: MediaQuery.of(context).size.height,
          decoration: const BoxDecoration(color: Colors.black),
          child: Stack(
            children: [
              TTVideoPlayerView(
                onPlatformViewCreated: (int viewId) {
                  _player.setPlayerContainerView(viewId);
                },
              ),
              Container(
                width: MediaQuery.of(context).size.width,
                height: MediaQuery.of(context).size.height,
                decoration: const BoxDecoration(color: Colors.transparent),
              ),
              Center(child: isPlaying()),

              Positioned(
                  left: 0,
                  top: 100,
                  child: Container(
                    padding:
                    const EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                    color: Colors.green,
                    child: Text(
                      'vod',
                      style: TextStyle(color: Colors.white),
                    ),
                  )),
            ],
          ),
        ),
      ),
    );
  }


  Widget isPlaying() {
    return _isPlaying
        ? const SizedBox()
        : Image.asset(
      'assets/images/icon_play.png',
      width: 80,
      height: 80,
    );
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _player.stop();
    _player.closeAsync();
  }
}
