//
//  setting_activity_page.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:bdlive_flutter_viewer/bdlive_flutter_viewer.dart';
import 'package:flutter/material.dart';

import 'common_radio_form_item.dart';
import 'l10n/app_localizations.dart';
import 'live_room_status_listener_example.dart';

class SettingActivityPage extends StatefulWidget {
  const SettingActivityPage({super.key});

  @override
  State<SettingActivityPage> createState() => _SettingActivityPageState();
}

class _SettingActivityPageState extends State<SettingActivityPage> {
  final TextEditingController _activityIdController =
      TextEditingController(text: "1791316363675665");
  final TextEditingController _tokenController = TextEditingController(
      text: "nJglPa2UUdS8+8vd68gO4NdeBp1hzNRHvDigqZroeTE=");
  var _isLoading = false;

  BdlViewerAuthMode _authMode = BdlViewerAuthMode.custom;
  bool _isPortrait = true;
  bool _autoShowView = false;

  void enterLiveRoom() async {
    setState(() {
      _isLoading = true;
    });

    var activityId = int.parse(_activityIdController.text);
    var token = _tokenController.text;
    BdlActivityConfig activity = BdlActivityConfig(
        activityId: activityId,
        token: token,
        authMode: _authMode,
        isPortrait: _isPortrait);

    BdlLiveRoomStatusListenerExampleImpl.instance.activity = activity;
    BdlLiveRoomStatusListenerExampleImpl.instance.autoShowView = _autoShowView;
    BdliveViewerApi.instance.setLiveRoomStatusListener(BdlLiveRoomStatusListenerExampleImpl.instance);

    var isPreLoadSuccess = _autoShowView ?
      await BdliveViewerApi.instance.enterLiveRoom(activity) :
      await BdliveViewerApi.instance.enterLiveRoomLogically(activity);
    setState(() {
      _isLoading = false;
    });
    if (!isPreLoadSuccess) {
      BdliveViewerApi.instance.setLiveRoomStatusListener(null);
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(AppLocalizations.of(context)!.liveRoom),
      ),
      body: ListView(
        padding: EdgeInsets.all(10),
        children: [
          TextField(
            controller: _activityIdController,
            keyboardType: TextInputType.number,
            decoration: InputDecoration(
                hintText: AppLocalizations.of(context)!.pleaseEnterActivityId,
                hintStyle: TextStyle(fontSize: 16, color: Colors.grey),
                suffixIcon: IconButton(
                    onPressed: () {
                      _activityIdController.clear();
                    },
                    icon: Icon(Icons.clear))),
          ),
          const SizedBox(
            height: 10,
          ),
          TextField(
            controller: _tokenController,
            decoration: InputDecoration(
                hintText: AppLocalizations.of(context)!.pleaseEnterToken,
                hintStyle: TextStyle(fontSize: 16, color: Colors.grey),
                suffixIcon: IconButton(
                    onPressed: () {
                      _tokenController.clear();
                    },
                    icon: Icon(Icons.clear))),
          ),
          const SizedBox(
            height: 10,
          ),
          CommonRadioFormItem(
            AppLocalizations.of(context)!.authMode,
            options: [
              AppLocalizations.of(context)!.authModeCustom,
              AppLocalizations.of(context)!.authModePublic,
            ],
            values: const [
              BdlViewerAuthMode.custom,
              BdlViewerAuthMode.public,
            ],
            groupValue: _authMode,
            onChanged: (val) {
              setState(() {
                _authMode = val!;
              });
            },
          ),
          CommonRadioFormItem(AppLocalizations.of(context)!.landscapeOrPortrait,
              options: [
                AppLocalizations.of(context)!.landscape,
                AppLocalizations.of(context)!.portrait
              ],
              values: const [false, true],
              groupValue: _isPortrait, onChanged: (val) {
            setState(() {
              _isPortrait = val!;
            });
          }),
          const SizedBox(
            height: 10,
          ),
          CommonRadioFormItem(AppLocalizations.of(context)!.autoShowView, options: [
            AppLocalizations.of(context)!.open,
            AppLocalizations.of(context)!.close,
          ], values: const [true, false], groupValue: _autoShowView, onChanged: (val) {
            setState(() {
              _autoShowView = val!;
            });
          }),
          const SizedBox(
            height: 30,
          ),
          ElevatedButton(
            onPressed: () {
              if (_activityIdController.text.trim().isEmpty) {
                print('activityId cannot be empty');
                return;
              }
              if (_tokenController.text.trim().isEmpty) {
                print('token cannot be empty');
                return;
              }
              // Hide keyboard
              FocusScope.of(context).unfocus();

              enterLiveRoom();
            },
            child: Text(_isLoading ? AppLocalizations.of(context)!.joining : AppLocalizations.of(context)!.enterLiveRoom),
          ),
          const SizedBox(
            height: 20,
          ),
        ],
      ),
    );
  }
}
