//
//  product_detail_page.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:bdlive_flutter_viewer/bdlive_flutter_viewer.dart';
import 'package:flutter/material.dart';

class ProductDetailPage extends StatefulWidget {
  static bool pageIsExist = false;

  final BdlActivityConfig activity;
  final String url;
  final BdlViewerOpenUrlType type;
  final bool enableFloating;
  bool isShowBackArrow;
  bool isAutoShowView;

  ProductDetailPage(
      {super.key,
      required this.activity,
      required this.url,
      required this.type,
      required this.enableFloating,
      this.isShowBackArrow = true,
      required this.isAutoShowView});

  @override
  State<ProductDetailPage> createState() => _ProductDetailPageState();
}

class _ProductDetailPageState extends State<ProductDetailPage> {
  bool isShowExitDetailButtonFlag = true;

  @override
  void dispose() {
    super.dispose();

    ProductDetailPage.pageIsExist = false;
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('Product Detail Page'),
        automaticallyImplyLeading: widget
            .isShowBackArrow, // false: Remove the back arrow from the appBar
      ),
      body: WillPopScope(
        onWillPop: () async => widget.isShowBackArrow,
        // false: Disable the back gesture
        child: Center(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Text('url: ${widget.url}'),
              Text('type: ${widget.type}'),
              Text('enableFloating: ${widget.enableFloating}'),
              const SizedBox(
                height: 20,
              ),
              if (isShowExitDetailButtonFlag) ...[
                ElevatedButton(
                  onPressed: () {
                    print("onPressed--");
                    if (widget.isAutoShowView) {
                      BdliveViewerApi.instance.enterLiveRoom(widget.activity);
                    }
                    Navigator.of(context).pop();
                    ProductDetailPage.pageIsExist = false;
                  },
                  child: Text('Exit Detail Page and Return to Live Room'),
                ),
                const SizedBox(
                  height: 20,
                ),
                ElevatedButton(
                  onPressed: () {
                    print("onPressed--");
                    setState(() {
                      isShowExitDetailButtonFlag = false;
                      widget.isShowBackArrow = true;
                    });
                    if (widget.isAutoShowView) {
                      BdliveViewerApi.instance.leaveLiveRoom();
                    }
                    else {
                      BdliveViewerApi.instance.leaveLiveRoomLogically();
                    }
                  },
                  child: Text('Exit Live Room'),
                ),
              ],
            ],
          ),
        ),
      ),
    );
  }
}
