//
//  main.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'dart:io';
import 'package:bdlive_flutter_viewer_example/ve_vod/vod_util.dart';
import 'package:flutter/material.dart';
import 'package:bdlive_flutter_viewer/bdlive_flutter_viewer.dart';
import 'home_page.dart';
import 'liveroom_config.dart';
import 'l10n/app_localizations.dart';
import 'global.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  @override
  void initState() {
    super.initState();

    LiveRoomConfig().addListener(() {
      setState(() {});
    });

    String channel = Platform.isAndroid ? 'your channel' : 'App Store';

    TTSDKConfiguration config = TTSDKConfiguration(
      appID: '407390',
      bundleID: 'com.bytedance.videoarch.TTLiveStream',
      appName: 'PullDemo',
      channel: channel,
      liveLicenseFilePath: 'Licenses/TTSDK/l-101585-ch-live-a-407390.lic',
      vodLicenseFilePath: 'Licenses/TTSDK/l-101586-ch-vod-a-407390.lic',
      appVersion: '1.0.0',
    );
    BdliveViewerManager.startWithConfiguration(config);

    //2
    VodUtil.initPlatformState(config.toMap());
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      navigatorKey: navigatorKey,
      locale: Locale(LiveRoomConfig().language),
      localizationsDelegates: AppLocalizations.localizationsDelegates,
      supportedLocales: AppLocalizations.supportedLocales,
      home: const HomePage(),
    );
  }
}
