//
//  liveroom_config_page.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:flutter/material.dart';
import 'common_radio_form_item.dart';
import 'liveroom_config.dart';
import 'l10n/app_localizations.dart';

class LiveRoomConfigPage extends StatefulWidget {
  const LiveRoomConfigPage({super.key});

  @override
  State<LiveRoomConfigPage> createState() => _LiveRoomConfigPageState();
}

class _LiveRoomConfigPageState extends State<LiveRoomConfigPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: Text(AppLocalizations.of(context)!.settings)),
      body: Padding(
        padding: const EdgeInsets.all(2.0),
        child: ListView(
          children: [
            CommonRadioFormItem(
              AppLocalizations.of(context)!.language,
              options: ["English", "简体中文"],
              values: const [kLanguageEn, kLanguageZh],
              groupValue: LiveRoomConfig().language,
              onChanged: (val) {
                setState(() {
                  LiveRoomConfig().language = val!;
                  
                });
              },
            ),
            CommonRadioFormItem(
              AppLocalizations.of(context)!.openUrlMethod,
              options: [AppLocalizations.of(context)!.openNewPage, AppLocalizations.of(context)!.sdkDefaultOpen],
              values: const [kOpenUrlTypeNewPage, kOpenUrlTypeSdkDefaultOpen],
              groupValue: LiveRoomConfig().openUrlType,
              onChanged: (val) {
                setState(() {
                  LiveRoomConfig().openUrlType = val!;
                });
              },
            ),
            CommonRadioFormItem(
              AppLocalizations.of(context)!.enablePIP,
              options: [AppLocalizations.of(context)!.open, AppLocalizations.of(context)!.close],
              values: const [true, false],
              groupValue: LiveRoomConfig().viewerConfig.playerConfig.enablePIP,
              onChanged: (val) {
                setState(() {
                  LiveRoomConfig().viewerConfig.playerConfig.enablePIP = val!;
                });
              },
            ),
            CommonRadioFormItem(
              AppLocalizations.of(context)!.enablePIPWhenExit,
              options: [AppLocalizations.of(context)!.open, AppLocalizations.of(context)!.close],
              values: const [true, false],
              groupValue: LiveRoomConfig().viewerConfig.playerConfig.enablePIPWhenExit,
              onChanged: (val) {
                setState(() {
                  LiveRoomConfig().viewerConfig.playerConfig.enablePIPWhenExit = val!;
                });
              },
            ),
            CommonRadioFormItem(
              AppLocalizations.of(context)!.liveAutoPlay,
              options:  [AppLocalizations.of(context)!.open, AppLocalizations.of(context)!.close],
              values: const [true, false],
              groupValue: LiveRoomConfig().viewerConfig.playerConfig.liveAutoPlay,
              onChanged: (val) {
                setState(() {
                  LiveRoomConfig().viewerConfig.playerConfig.liveAutoPlay = val!;
                });
              },
            ),
            CommonRadioFormItem(
              AppLocalizations.of(context)!.previewAutoPlay,
              options: [AppLocalizations.of(context)!.open, AppLocalizations.of(context)!.close],
              values: const [true, false],
              groupValue: LiveRoomConfig().viewerConfig.playerConfig.previewAutoPlay,
              onChanged: (val) {
                setState(() {
                  LiveRoomConfig().viewerConfig.playerConfig.previewAutoPlay = val!;
                });
              },
            ),
            CommonRadioFormItem(
              AppLocalizations.of(context)!.replayAutoPlay,
              options: [AppLocalizations.of(context)!.open, AppLocalizations.of(context)!.close],
              values: const [true, false],
              groupValue: LiveRoomConfig().viewerConfig.playerConfig.replayAutoPlay,
              onChanged: (val) {
                setState(() {
                  LiveRoomConfig().viewerConfig.playerConfig.replayAutoPlay = val!;
                });
              },
            ),
          ],
        ),
      ),
    );
  }

  @override
  void dispose() {
    // 保存配置到本地
    _saveConfig();
    super.dispose();
  }

  Future<void> _saveConfig() async {
    LiveRoomConfig().saveConfig();
    debugPrint('save config');
  }
}
