//
//  liveroom_config.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:bdlive_flutter_viewer/bdlive_flutter_viewer.dart';
import 'package:flutter/foundation.dart';
import 'l10n/app_localizations.dart';

const int kOpenUrlTypeNewPage = 1;
const int kOpenUrlTypeSdkDefaultOpen = 2;

const String kLanguageZh = 'zh';
const String kLanguageEn = 'en';

class LiveRoomConfig with ChangeNotifier {
  static final LiveRoomConfig _instance = LiveRoomConfig._internal();
  factory LiveRoomConfig() => _instance;
  LiveRoomConfig._internal();

  String _language = _getSystemLanguage();

  String get language => _language;

  set language(String value) {
    if (_language != value) {
      _language = value;
      notifyListeners();
    }
  }

  static String _getSystemLanguage() {
    final systemLocales = PlatformDispatcher.instance.locales;
    final supported = AppLocalizations.supportedLocales.map((e) => e.languageCode);
    
    for (final locale in systemLocales) {
      if (supported.contains(locale.languageCode)) {
        return locale.languageCode;
      }
    }
    return 'en';
  }
  int openUrlType = kOpenUrlTypeNewPage;
  late BdLiveViewerConfig viewerConfig = BdliveViewerApi.instance.getLiveRoomConfig();

  Future<void> saveConfig() async {
    await BdliveViewerApi.instance.setLiveRoomConfig(viewerConfig);
  }
}
