//
//  live_room_page.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:flutter/material.dart';
import 'package:bdlive_flutter_viewer/bdlive_flutter_viewer.dart';

import 'live_room_status_listener_example.dart';

class LiveRoomPage extends StatefulWidget {
  const LiveRoomPage({super.key});

  @override
  State<LiveRoomPage> createState() => _LiveRoomPageState();
}

class _LiveRoomPageState extends State<LiveRoomPage> {
  @override
  Widget build(BuildContext context) {
    MediaQueryData mediaQueryData = MediaQuery.of(context);
    return SizedBox(
          width: mediaQueryData.size.width,
          height: mediaQueryData.size.height,
          child: Stack(
            children: [
              BdlLivePullView(
                onPlatformViewCreated: () {
                },
              ),
              // Floating window button - blue background, black text, with the content "Leave"
              Positioned(
                bottom: 200,
                left: 20,
                child: ElevatedButton(
                  style: ElevatedButton.styleFrom(
                    backgroundColor: Colors.blue,
                    padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 10),
                    shape: RoundedRectangleBorder(
                      borderRadius: BorderRadius.circular(20),
                    ),
                  ),
                  onPressed: () {
                    if (BdlLiveRoomStatusListenerExampleImpl.instance.autoShowView) {
                      BdliveViewerApi.instance.leaveLiveRoom();
                    }
                    else {
                      BdliveViewerApi.instance.leaveLiveRoomLogically();
                    }
                  },
                  child: const Text(
                    'Exit',
                    style: TextStyle(
                      color: Colors.black,
                      fontSize: 16,
                      fontWeight: FontWeight.bold,
                    ),
                  ),
                ),
              ),
            ],
          ),
        );
  }
  
  @override
  void dispose() {
    debugPrint('LiveRoomPage disposed');
    super.dispose();
  }
}
