//
//  app_localizations_zh.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get home => '首页';

  @override
  String get settings => '配置';

  @override
  String get liveRoom => '完整直播间';

  @override
  String get feed => 'Feed 流';

  @override
  String get purePlayerView => '纯净播放器';

  @override
  String get openUrlMethod => '打开 URL';

  @override
  String get sdkDefaultOpen => 'SDK 默认打开';

  @override
  String get openNewPage => '新页面打开';

  @override
  String get enablePIP => 'Enable PIP';

  @override
  String get open => '开启';

  @override
  String get close => '关闭';

  @override
  String get enablePIPWhenExit => '退出时开启 PIP';

  @override
  String get liveAutoPlay => '直播自动播放';

  @override
  String get previewAutoPlay => '预览自动播放';

  @override
  String get replayAutoPlay => '回放自动播放';

  @override
  String get authMode => '鉴权模式';

  @override
  String get authModePublic => '公开';

  @override
  String get authModeCustom => '自定义';

  @override
  String get landscapeOrPortrait => '横屏或竖屏';

  @override
  String get landscape => '横屏';

  @override
  String get portrait => '竖屏';

  @override
  String get autoShowView => '自动展示视图';

  @override
  String get pleaseEnterActivityId => '请输入活动ID';

  @override
  String get pleaseEnterToken => '请输入 Token';

  @override
  String get joining => '进入直播中...';

  @override
  String get enterLiveRoom => '进入直播';

  @override
  String get unknown => '未知';

  @override
  String get live => '直播中';

  @override
  String get preview => '预告';

  @override
  String get replay => '回放';

  @override
  String get speed => '倍速';

  @override
  String get resolution => '分辨率';

  @override
  String get refreshLiveContent => '刷新当前直播内容';

  @override
  String get showCover => '显示封面图';

  @override
  String get hideCover => '隐藏封面图';

  @override
  String get fillMode => '填充模式';

  @override
  String get playSpeed => '播放速度';

  @override
  String get currentPlaybackTime => '当前播放时间';

  @override
  String get seekTo => '跳转到';

  @override
  String get language => '语言';
}
