//
//  app_localizations_en.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get home => 'Home';

  @override
  String get settings => 'Settings';

  @override
  String get liveRoom => 'Live room';

  @override
  String get feed => 'Feed';

  @override
  String get purePlayerView => 'Pure player view';

  @override
  String get openUrlMethod => 'Open URL method';

  @override
  String get sdkDefaultOpen => 'SDK default open';

  @override
  String get openNewPage => 'Open new page';

  @override
  String get enablePIP => 'Enable PIP';

  @override
  String get open => 'true';

  @override
  String get close => 'false';

  @override
  String get enablePIPWhenExit => 'Enable PIP when exit';

  @override
  String get liveAutoPlay => 'Live auto play';

  @override
  String get previewAutoPlay => 'Preview auto play';

  @override
  String get replayAutoPlay => 'Replay auto play';

  @override
  String get authMode => 'Auth mode';

  @override
  String get authModePublic => 'Public';

  @override
  String get authModeCustom => 'Custom';

  @override
  String get landscapeOrPortrait => 'Landscape or Portrait';

  @override
  String get landscape => 'Landscape';

  @override
  String get portrait => 'Portrait';

  @override
  String get autoShowView => 'Auto show view';

  @override
  String get pleaseEnterActivityId => 'Please enter activityId';

  @override
  String get pleaseEnterToken => 'Please enter token';

  @override
  String get joining => 'Joining...';

  @override
  String get enterLiveRoom => 'Enter Live Room';

  @override
  String get unknown => 'Unknown';

  @override
  String get live => 'Live';

  @override
  String get preview => 'Preview';

  @override
  String get replay => 'Replay';

  @override
  String get speed => 'Speed';

  @override
  String get resolution => 'Resolution';

  @override
  String get refreshLiveContent => 'Refresh live content';

  @override
  String get showCover => 'Show cover';

  @override
  String get hideCover => 'Hide cover';

  @override
  String get fillMode => 'Fill mode';

  @override
  String get playSpeed => 'Play speed';

  @override
  String get currentPlaybackTime => 'Current playback time';

  @override
  String get seekTo => 'Seek to';

  @override
  String get language => 'Language';
}
