//
//  app_localizations.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'app_localizations_en.dart';
import 'app_localizations_zh.dart';

// ignore_for_file: type=lint

/// Callers can lookup localized strings with an instance of AppLocalizations
/// returned by `AppLocalizations.of(context)`.
///
/// Applications need to include `AppLocalizations.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'l10n/app_localizations.dart';
///
/// return MaterialApp(
///   localizationsDelegates: AppLocalizations.localizationsDelegates,
///   supportedLocales: AppLocalizations.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the AppLocalizations.supportedLocales
/// property.
abstract class AppLocalizations {
  AppLocalizations(String locale)
      : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static AppLocalizations? of(BuildContext context) {
    return Localizations.of<AppLocalizations>(context, AppLocalizations);
  }

  static const LocalizationsDelegate<AppLocalizations> delegate =
      _AppLocalizationsDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates =
      <LocalizationsDelegate<dynamic>>[
    delegate,
    GlobalMaterialLocalizations.delegate,
    GlobalCupertinoLocalizations.delegate,
    GlobalWidgetsLocalizations.delegate,
  ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('en'),
    Locale('zh')
  ];

  /// No description provided for @home.
  ///
  /// In en, this message translates to:
  /// **'Home'**
  String get home;

  /// No description provided for @settings.
  ///
  /// In en, this message translates to:
  /// **'Settings'**
  String get settings;

  /// No description provided for @liveRoom.
  ///
  /// In en, this message translates to:
  /// **'Live room'**
  String get liveRoom;

  /// No description provided for @feed.
  ///
  /// In en, this message translates to:
  /// **'Feed'**
  String get feed;

  /// No description provided for @purePlayerView.
  ///
  /// In en, this message translates to:
  /// **'Pure player view'**
  String get purePlayerView;

  /// No description provided for @openUrlMethod.
  ///
  /// In en, this message translates to:
  /// **'Open URL method'**
  String get openUrlMethod;

  /// No description provided for @sdkDefaultOpen.
  ///
  /// In en, this message translates to:
  /// **'SDK default open'**
  String get sdkDefaultOpen;

  /// No description provided for @openNewPage.
  ///
  /// In en, this message translates to:
  /// **'Open new page'**
  String get openNewPage;

  /// No description provided for @enablePIP.
  ///
  /// In en, this message translates to:
  /// **'Enable PIP'**
  String get enablePIP;

  /// No description provided for @open.
  ///
  /// In en, this message translates to:
  /// **'true'**
  String get open;

  /// No description provided for @close.
  ///
  /// In en, this message translates to:
  /// **'false'**
  String get close;

  /// No description provided for @enablePIPWhenExit.
  ///
  /// In en, this message translates to:
  /// **'Enable PIP when exit'**
  String get enablePIPWhenExit;

  /// No description provided for @liveAutoPlay.
  ///
  /// In en, this message translates to:
  /// **'Live auto play'**
  String get liveAutoPlay;

  /// No description provided for @previewAutoPlay.
  ///
  /// In en, this message translates to:
  /// **'Preview auto play'**
  String get previewAutoPlay;

  /// No description provided for @replayAutoPlay.
  ///
  /// In en, this message translates to:
  /// **'Replay auto play'**
  String get replayAutoPlay;

  /// No description provided for @authMode.
  ///
  /// In en, this message translates to:
  /// **'Auth mode'**
  String get authMode;

  /// No description provided for @authModePublic.
  ///
  /// In en, this message translates to:
  /// **'Public'**
  String get authModePublic;

  /// No description provided for @authModeCustom.
  ///
  /// In en, this message translates to:
  /// **'Custom'**
  String get authModeCustom;

  /// No description provided for @landscapeOrPortrait.
  ///
  /// In en, this message translates to:
  /// **'Landscape or Portrait'**
  String get landscapeOrPortrait;

  /// No description provided for @landscape.
  ///
  /// In en, this message translates to:
  /// **'Landscape'**
  String get landscape;

  /// No description provided for @portrait.
  ///
  /// In en, this message translates to:
  /// **'Portrait'**
  String get portrait;

  /// No description provided for @autoShowView.
  ///
  /// In en, this message translates to:
  /// **'Auto show view'**
  String get autoShowView;

  /// No description provided for @pleaseEnterActivityId.
  ///
  /// In en, this message translates to:
  /// **'Please enter activityId'**
  String get pleaseEnterActivityId;

  /// No description provided for @pleaseEnterToken.
  ///
  /// In en, this message translates to:
  /// **'Please enter token'**
  String get pleaseEnterToken;

  /// No description provided for @joining.
  ///
  /// In en, this message translates to:
  /// **'Joining...'**
  String get joining;

  /// No description provided for @enterLiveRoom.
  ///
  /// In en, this message translates to:
  /// **'Enter Live Room'**
  String get enterLiveRoom;

  /// No description provided for @unknown.
  ///
  /// In en, this message translates to:
  /// **'Unknown'**
  String get unknown;

  /// No description provided for @live.
  ///
  /// In en, this message translates to:
  /// **'Live'**
  String get live;

  /// No description provided for @preview.
  ///
  /// In en, this message translates to:
  /// **'Preview'**
  String get preview;

  /// No description provided for @replay.
  ///
  /// In en, this message translates to:
  /// **'Replay'**
  String get replay;

  /// No description provided for @speed.
  ///
  /// In en, this message translates to:
  /// **'Speed'**
  String get speed;

  /// No description provided for @resolution.
  ///
  /// In en, this message translates to:
  /// **'Resolution'**
  String get resolution;

  /// No description provided for @refreshLiveContent.
  ///
  /// In en, this message translates to:
  /// **'Refresh live content'**
  String get refreshLiveContent;

  /// No description provided for @showCover.
  ///
  /// In en, this message translates to:
  /// **'Show cover'**
  String get showCover;

  /// No description provided for @hideCover.
  ///
  /// In en, this message translates to:
  /// **'Hide cover'**
  String get hideCover;

  /// No description provided for @fillMode.
  ///
  /// In en, this message translates to:
  /// **'Fill mode'**
  String get fillMode;

  /// No description provided for @playSpeed.
  ///
  /// In en, this message translates to:
  /// **'Play speed'**
  String get playSpeed;

  /// No description provided for @currentPlaybackTime.
  ///
  /// In en, this message translates to:
  /// **'Current playback time'**
  String get currentPlaybackTime;

  /// No description provided for @seekTo.
  ///
  /// In en, this message translates to:
  /// **'Seek to'**
  String get seekTo;

  /// No description provided for @language.
  ///
  /// In en, this message translates to:
  /// **'Language'**
  String get language;
}

class _AppLocalizationsDelegate
    extends LocalizationsDelegate<AppLocalizations> {
  const _AppLocalizationsDelegate();

  @override
  Future<AppLocalizations> load(Locale locale) {
    return SynchronousFuture<AppLocalizations>(lookupAppLocalizations(locale));
  }

  @override
  bool isSupported(Locale locale) =>
      <String>['en', 'zh'].contains(locale.languageCode);

  @override
  bool shouldReload(_AppLocalizationsDelegate old) => false;
}

AppLocalizations lookupAppLocalizations(Locale locale) {
  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'en':
      return AppLocalizationsEn();
    case 'zh':
      return AppLocalizationsZh();
  }

  throw FlutterError(
      'AppLocalizations.delegate failed to load unsupported locale "$locale". This is likely '
      'an issue with the localizations generation tool. Please file an issue '
      'on GitHub with a reproducible sample app and the gen-l10n configuration '
      'that was used.');
}
