//
//  home_page.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:bdlive_flutter_viewer/bdlive_flutter_viewer.dart';
import 'package:bdlive_flutter_viewer_example/feed/feed_list_page.dart';
import 'package:bdlive_flutter_viewer_example/liveroom_config_page.dart';
import 'package:flutter/material.dart';

import 'feed/data.dart';
import 'feed/play_page.dart';
import 'setting_activity_page.dart';
import 'l10n/app_localizations.dart';

class HomePage extends StatelessWidget {
  const HomePage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(AppLocalizations.of(context)!.home),
      ),
      body: Center(
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            ElevatedButton(
                onPressed: () {
                  Navigator.of(context)
                      .push(MaterialPageRoute(builder: (context) {
                    var data = dataList[0];
                    int activityId = data['id'];
                    String token = data['token'];
                    BdlViewerAuthMode authMode =
                        BdlViewerAuthMode.values[data['mode']];
                    BdlViewerPlayerConfig activity = BdlViewerPlayerConfig(
                      activityId: activityId,
                      token: token,
                      authMode: authMode,
                    );

                    return PlayerPage(activity: activity);
                  }));
                },
                child: Text(AppLocalizations.of(context)!.purePlayerView)),
/*
            ElevatedButton(onPressed: () {
              Navigator.of(context).push(MaterialPageRoute(builder: (context) {
                return VodPage(url: 'https://static.ybhospital.net/test-video-4.mp4',);
              }));
            }, child: Text('vod播放器')),

 */

            const SizedBox(height: 20),
            ElevatedButton(
                onPressed: () {
                  Navigator.of(context)
                      .push(MaterialPageRoute(builder: (context) {
                    return const FeedListPage();
                  }));
                },
                child: Column(
                  children: [
                    Text(AppLocalizations.of(context)!.feed),
                  ],
                )),
            const SizedBox(height: 20),
            ElevatedButton(
                onPressed: () {
                  Navigator.of(context).push(MaterialPageRoute(
                    builder: (context) => const SettingActivityPage(),
                    settings: const RouteSettings(name: 'SettingActivityPage'),
                  ));
                },
                child: Text(AppLocalizations.of(context)!.liveRoom)),
            const SizedBox(height: 20),
            ElevatedButton(
                onPressed: () {
                  Navigator.of(context)
                      .push(MaterialPageRoute(builder: (context) {
                    return const LiveRoomConfigPage();
                  }));
                },
                child: Text(AppLocalizations.of(context)!.settings)),
          ],
        ),
      ),
    );
  }
}
