//
//  feed_list_page.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:bdlive_flutter_viewer/bdlive_flutter_viewer.dart';
import 'package:bdlive_flutter_viewer_example/feed/data.dart';
import 'package:bdlive_flutter_viewer_example/ve_vod/vod_page.dart';
import 'package:flutter/material.dart';

import 'feed_page.dart';
import 'play_page.dart';

class FeedListPage extends StatefulWidget {
  const FeedListPage({super.key});

  @override
  State<FeedListPage> createState() => _FeedListPageState();
}

class _FeedListPageState extends State<FeedListPage> {

  late PageController _pageController;
  int currentPageIndex = 0; //当前播放索引
  List<Map<String, dynamic>> videoDataList = []; //视频数据列表

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _pageController = PageController(initialPage: 0);
    _pageController.addListener(_onPageScroll);
    loadData(false);
  }

  void _onPageScroll() {
    final pageIndex = _pageController.page?.round();
    if (pageIndex != null && pageIndex != currentPageIndex) {
      currentPageIndex = pageIndex;
      print('=========> currentPageIndex: ${currentPageIndex}');
      if (currentPageIndex == videoDataList.length - 2) {
        debugPrint("加载更多...");
        loadData(true);
      }
    }
  }

  /// 视频数据 API请求
  Future<void> loadData(bool isLoadMore) async {
    await Future.delayed(const Duration(milliseconds: 200));
    if (isLoadMore) {
      List<Map<String, dynamic>> newVideoDataList = [];
      newVideoDataList.addAll(videoDataList);
      newVideoDataList.addAll(dataList);
      setState(() {
        videoDataList = newVideoDataList;
      });
    } else {
      setState(() {
        videoDataList = dataList;
      });
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(

      body: PageView.builder(
          controller: _pageController,
          scrollDirection: Axis.vertical,
          itemCount: videoDataList.length,
          itemBuilder: (ctx, index) {
            return Container(
              // child: Center(child: Text('${videoDataList[index]['index']}')),
              child: createPage(index),
            );
          }),
    );
  }

  Widget createPage(int index) {
    int type = videoDataList[index]['type'];
    if (type == 0) {
      var data = videoDataList[index];
      int activityId = data['id'];
      String token = data['token'];
      BdlViewerAuthMode authMode = BdlViewerAuthMode.values[data['mode']];
      debugPrint(authMode.toString());
      BdlViewerPlayerConfig activity = BdlViewerPlayerConfig(
          activityId: activityId,
          token: token,
          authMode: authMode);
      return FeedPage(activity: activity);
    } else {
      String url = videoDataList[index]['url'];
      return VodPage(url: url);
    }
  }

}

