//
//  common_radio_form_item.dart
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';

class CommonRadioFormItem<T> extends StatelessWidget {
  final String label;
  final List<String> options;
  final List<T> values;
  final T? groupValue;
  final ValueChanged<T?>? onChanged;

  const CommonRadioFormItem(this.label, {
    super.key,
    required this.options,
    required this.values,
    this.groupValue,
    this.onChanged,
  });

  @override
  Widget build(BuildContext context) {
    return ListBody(
      children: [
        Container(
          margin: const EdgeInsets.symmetric(vertical: 10, horizontal: 10),
          child: Text(
            label,
            style: const TextStyle(fontSize: 16.0, color: Colors.black87),
          ),
        ),
        Container(
          margin: const EdgeInsets.symmetric(vertical: 10, horizontal: 10),
          child: Wrap(
            children: List.generate(
                options.length,
                (index) => Row(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    const SizedBox(width: 10,),
                    Radio<T>(
                        value: values[index],
                        groupValue: groupValue,
                        onChanged: onChanged),
                    Text(options[index]),
                  ],
                )),
          ),
        )
      ],
    );
  }
}
