//
//  BdlActivity.java
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
package com.example.bdlive_flutter_viewer.vo;

import java.util.HashMap;
import java.util.Map;

public class BdlActivity {
    private Long activityId;
    private String token;
    private Integer authMode;
    private Boolean isPortrait;

    public BdlActivity(Long activityId, String token, Integer authMode, Boolean isPortrait) {
        this.activityId = activityId;
        this.token = token;
        this.authMode = authMode;
        this.isPortrait = isPortrait;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Integer getAuthMode() {
        return authMode;
    }

    public void setAuthMode(Integer authMode) {
        this.authMode = authMode;
    }

    public Boolean getPortrait() {
        return isPortrait;
    }

    public void setPortrait(Boolean portrait) {
        isPortrait = portrait;
    }

    public boolean isValid() {
        if (activityId == null || authMode == null || isPortrait == null) {
            return false;
        }
        if (authMode != 1 && authMode != 2) {
            return false;
        }
        return true;
    }

    public Map<String, Object> generateFlutterMap() {
        Map<String, Object> map = new HashMap<>();
        map.put("activityId", activityId);
        map.put("token", token);
        map.put("authMode", authMode);
        map.put("isPortrait", isPortrait);
        return map;
    }

}
