//
//  BDLVideoResolution.java
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
package com.example.bdlive_flutter_viewer.vo;

import com.bytedance.live.common.utils.ServerUtil;
import com.bytedance.live.common.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;

public enum BDLVideoResolution {
    BDLVideoResolutionUnknown(0),
    BDLVideoResolutionLD(1),
    BDLVideoResolutionSD(2),
    BDLVideoResolutionHD(3),
    BDLVideoResolutionUHD(4),
    BDLVideoResolutionBD(5),
    BDLVideoResolutionOrigin(6),
    BDLVideoResolutionAuto(7),
    ;
    public int value;

    BDLVideoResolution(int value) {
        this.value = value;
    }

    public static BDLVideoResolution findBDLVideoResolution(Integer value) {
        if (value == null) {
            return null;
        }
        BDLVideoResolution resolution = null;
        for (BDLVideoResolution videoResolution : BDLVideoResolution.values()) {
            if (videoResolution.value == value) {
                resolution = videoResolution;
            }
        }
        return resolution;
    }

    public static List<Integer> castStrList2ResolutionIntList(String[] strings) {
        List<Integer> resolutions = new ArrayList<>();
        if (strings != null) {
            for (String s : strings) {
                BDLVideoResolution videoResolution = castStr2BDLVideoResolution(s);
                if (videoResolution != null) {
                    resolutions.add(videoResolution.value);
                }
            }
        }
        return resolutions;
    }

    public static BDLVideoResolution castStr2BDLVideoResolution(String resolutionStr) {
        if (StringUtils.isEmpty(resolutionStr)) {
            return null;
        }
        BDLVideoResolution resolution = null;
        if (resolutionStr.equals("origin")) {
            resolution = BDLVideoResolution.BDLVideoResolutionOrigin;
        } else if (resolutionStr.equals("bd")) {
            resolution = BDLVideoResolution.BDLVideoResolutionBD;
        } else if (resolutionStr.equals("uhd")) {
            resolution = BDLVideoResolution.BDLVideoResolutionUHD;
        } else if (resolutionStr.equals("hd")) {
            resolution = BDLVideoResolution.BDLVideoResolutionHD;
        } else if (resolutionStr.equals("sd")) {
            resolution = BDLVideoResolution.BDLVideoResolutionSD;
        } else if (resolutionStr.equals("ld")) {
            resolution = BDLVideoResolution.BDLVideoResolutionLD;
        } else if (resolutionStr.equals("auto")) {
            resolution = BDLVideoResolution.BDLVideoResolutionAuto;
        }
        if (resolution != null) {
            return resolution;
        }

        int resolutionInt = 0;
        String lowerCase = resolutionStr.toLowerCase();
        String lastChar = lowerCase.substring(lowerCase.length() - 1);
        if (lastChar.equals("p")) {
            // 移除非数字字符并转换为整数
            String numericPart = resolutionStr.replaceAll("[^0-9]", "");
            if (!numericPart.isEmpty()) {
                resolutionInt = ServerUtil.castStr2Int(numericPart);
            }

            if (resolutionInt < 540) {
                resolution = BDLVideoResolution.BDLVideoResolutionLD;
            } else if (resolutionInt == 540) {
                resolution = BDLVideoResolution.BDLVideoResolutionSD;
            } else if (resolutionInt <= 720) {
                resolution = BDLVideoResolution.BDLVideoResolutionHD;
            } else if (resolutionInt <= 1080) {
                resolution = BDLVideoResolution.BDLVideoResolutionUHD;
            } else {
                resolution = BDLVideoResolution.BDLVideoResolutionBD;
            }
        } else if (lastChar.equals("k") || lastChar.equals("r")) {
            resolution = BDLVideoResolution.BDLVideoResolutionBD;
        }
        return resolution;
    }

}
