//
//  FlutterLivePlayerManager.java
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
package com.example.bdlive_flutter_viewer.player;

import com.example.bdlive_flutter_viewer.vo.BdlActivity;

import java.util.Collection;
import java.util.HashMap;

import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.platform.PlatformViewRegistry;

public class FlutterLivePlayerManager {
    HashMap<Integer, SingleLiveConnector> liveConnectorMap = new HashMap<Integer, SingleLiveConnector>();

    FlutterPlugin.FlutterPluginBinding binding;

    public FlutterLivePlayerManager(FlutterPlugin.FlutterPluginBinding binding) {
        this.binding = binding;
        BDLiveFlutterLiveViewFactory bdLiveFlutterVideoViewFactory = new BDLiveFlutterLiveViewFactory(binding, this);
        PlatformViewRegistry registry = binding.getPlatformViewRegistry();
        registry.registerViewFactory(BDLiveFlutterLiveViewFactory.VIEW_TYPE_ID,
                bdLiveFlutterVideoViewFactory);
    }

    public void createLivePlayer(Integer managerId, BdlActivity bdlActivity) {
        if (getLiveConnector(managerId) != null) {
            return;
        }
        SingleLiveConnector vodConnector = new SingleLiveConnector(managerId, bdlActivity, binding,
                this);
        liveConnectorMap.put(managerId, vodConnector);
    }

    public void destroyLivePlayer(Integer managerId) {
        SingleLiveConnector vodConnector = getLiveConnector(managerId);
        if (vodConnector == null) {
            return;
        }
        vodConnector.destroy();
        liveConnectorMap.remove(managerId);
    }

    public SingleLiveConnector getLiveConnector(Integer managerId) {
        return liveConnectorMap.get(managerId);
    }

    public void destroy() {
        Collection<SingleLiveConnector> values = liveConnectorMap.values();
        for (SingleLiveConnector connector : values) {
            if (connector != null) {
                connector.destroy();
            }
        }
        liveConnectorMap.clear();
    }
}
