//
//  BDLiveFlutterLiveViewFactory.java
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
package com.example.bdlive_flutter_viewer.player;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.Map;

import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.StandardMessageCodec;
import io.flutter.plugin.platform.PlatformView;
import io.flutter.plugin.platform.PlatformViewFactory;

public class BDLiveFlutterLiveViewFactory extends PlatformViewFactory {
    public static final String VIEW_TYPE_ID = "BdliveViewerPlayerView";

    FlutterPlugin.FlutterPluginBinding binding;
    FlutterLivePlayerManager manager;

    public BDLiveFlutterLiveViewFactory(FlutterPlugin.FlutterPluginBinding binding, FlutterLivePlayerManager manager) {
        super(StandardMessageCodec.INSTANCE);
        this.binding = binding;
        this.manager = manager;
    }

    @NonNull
    @Override
    public PlatformView create(Context context, int viewId, @Nullable Object args) {
        Integer managerId = null;
        // 假设 args 是 Map 类型
        if (args instanceof Map) {
            Map<String, Object> params = (Map<String, Object>) args;
            // 访问自定义参数
            managerId = (Integer) params.get("managerId");
        }
        return new BDLiveFlutterVideoPlatformView(binding, manager, managerId);
    }
}
