//
//  BDLivePullView.java
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
package com.example.bdlive_flutter_viewer.livev;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;

import com.bytedance.live.sdk.player.TVULiveRoom;
import com.bytedance.live.sdk.player.activity.roomview.BaseLiveRoomView;
import com.bytedance.live.sdk.player.activity.roomview.FlutterContainerHelper;
import com.bytedance.live.sdk.player.activity.roomview.JoinResultListener;
import com.bytedance.live.sdk.player.activity.roomview.JoinRoomConfig;
import com.bytedance.live.sdk.player.activity.roomview.LandRoomView;
import com.bytedance.live.sdk.player.activity.roomview.PortraitLiveRoomView;
import com.bytedance.live.sdk.player.core.EnterRoomManager;
import com.bytedance.live.sdk.player.core.JoinRoomData;
import com.example.bdlive_flutter_viewer.R;
import com.example.bdlive_flutter_viewer.vo.BdlActivity;

import java.util.UUID;

public class BDLivePullView extends FrameLayout {
    public static final String enterID = UUID.randomUUID().toString();
    private BaseLiveRoomView roomView;


    public BDLivePullView(@NonNull Context context) {
        super(context);
        LayoutInflater.from(context).inflate(R.layout.live_view_container, this, true);
        init(context);
    }

    private void init(Context context){
        ViewGroup roomViewContainer = findViewById(R.id.roomView_container);
        JoinRoomData data= EnterRoomManager.getInstance().getCachedJoinRoomData(enterID);
        BdlActivity bdlActivity = BdlActivityContainer.getBdlActivity();
        FlutterContainerHelper flutterContainerHelper = FlutterContainerHelperContainer.getFlutterContainerHelper();
        JoinRoomConfig joinRoomConfig=new JoinRoomConfig(bdlActivity.getActivityId(),bdlActivity.getToken(),bdlActivity.getAuthMode()==2 ? TVULiveRoom.TVURoomAuthMode.CUSTOM: TVULiveRoom.TVURoomAuthMode.PUBLIC);

        joinRoomConfig.preJoinRoomData=data;
        joinRoomConfig.joinResultListener = new JoinResultListener() {
            @Override
            public void onJoinSuccess() {

            }

            @Override
            public void onJoinFailed(int errCode, String errMsg) {

            }
        };

        if (bdlActivity.getPortrait()) {
            roomView = new PortraitLiveRoomView(context);
        } else {
            roomView = new LandRoomView(context);
        }
        roomViewContainer.addView(roomView, new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT));
        roomView.joinLiveRoom(flutterContainerHelper,joinRoomConfig);
    }


    public void destroy(){


    }

}
