//
//  FlutterEventChannelHelper.java
//
//  bdlive-flutter-viewer SDK License
//
//  Copyright 2025 Byteplus Pte. Ltd. All Rights Reserved.
//
//  The bdlive-flutter-viewer SDK was developed by Byteplus Pte. Ltd. (hereinafter “Byteplus”).
//  Any copyright or patent right is owned by and proprietary material of the Byteplus.
//
//  bdlive-flutter-viewer SDK is available under the Byteplus product and licensed under the commercial license.
//  Customers can contact via https://www.byteplus.com/en/contact for commercial licensing options.
//  Here is also a link to Service Level Agreement: https://docs.byteplus.com/en/byteplus-livesaas/docs/byteplus-live-service-level-agreement
//
//  Without Byteplus's prior written permission, any use of bdlive-flutter-viewer SDK, in particular any use for commercial purposes, is prohibited.
//  This includes, without limitation, incorporation in a commercial product, use in a commercial service, or production of other artefacts for commercial purposes.
//
//  Without Byteplus's prior written permission, the bdlive-flutter-viewer SDK may not be reproduced, modified and/or made available in any form to any third party.
package com.example.bdlive_flutter_viewer;

import java.util.Map;

import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.EventChannel;

public class FlutterEventChannelHelper {
    private EventChannel eventChannel;
    private EventChannel.EventSink eventSink;

    public FlutterEventChannelHelper(BinaryMessenger messenger, String channelName) {
        eventChannel = new EventChannel(messenger, channelName);
        eventChannel.setStreamHandler(new EventChannel.StreamHandler() {
            @Override
            public void onListen(Object arguments, EventChannel.EventSink events) {
                eventSink = events;
            }

            @Override
            public void onCancel(Object arguments) {
                releaseEventSink();
            }
        });
    }

    public void sendToFlutter(Map<String, Object> data) {
        if (eventSink != null) {
            eventSink.success(data);
        }
    }

    public void destroy() {
        releaseEventSink();
        eventChannel.setStreamHandler(null);
    }

    private void releaseEventSink() {
        if (eventSink != null) {
            eventSink.endOfStream();
            eventSink = null;
        }
    }
}